/**
* Script: timedvalue.js
* Written by: Radnen
* Updated: 1/4/2011
**/

/**
* TimedValue object:
*  - A value that grows and shrinks over time.
*  - setting the value will cause it to set the time and state.
*  - use update() to see the value change over time.
**/
function TimedValue(v, msecs)
{
	// the real-to-use value:
	this.value = v;
	this.duration = msecs;
	
	// private data:
	var old = v;
	var cur = v;
	var state;
	var time = 0;
	
	// updates any linear movement:
	this.update = function() {
		this.value = cur;
		state = (GetTime()-time) / this.duration;
		if (state < 1) this.value = old + (cur - old) * state;
		return (this.value != cur);
	}
	
	// used to scale the value over time:
	this.scale = function(new_value) {
		if (cur == new_value) return;
		state = (GetTime()-time) / this.duration;
		
		if (state > 1) state = 1;
		if (state < 1) old += (cur - old) * state;
		else old = cur;
		
		cur = new_value;
		time = GetTime();
	}
}